-- events for main menu


function OnLoad ()
	SetProperty ("/:enter_trans_duration", 1.00);
	SetProperty ("/:leave_trans_duration", 0.4);
	CacheSound ("ui/sfx/panel_move.ogg");
	CacheSound ("music/episodecomplete.ogg");
end;


function OnEnter ()

	StopMusic (2);
	PlaySound ("ui/sfx/panel_move.ogg");
	PlaySound ("music/episodecomplete.ogg");
	
	-- need to offset by -1 because the real level is actually already completed
	level_number = GetGameValue ("level_number")-1;
	episode = math.floor (level_number/7);
	
	--imagenumber = string.format("%04d", episode);
	--imagename = "worldmap/backgrounds/bg-"..imagenumber..".jpg";
	--SetProperty("bgimage:label.bitmap", imagename);
	
	val = DM_GetValue ("xml/story.xml", "minigame_story", episode-1, "bitmap");
	SetProperty ("pic:label.bitmap", val);

	val = DM_GetValue ("xml/story.xml", "minigame_story", episode-1, "title");
	SetProperty ("title:label.text", val);
	
	val = DM_GetValue ("xml/story.xml", "minigame_story", episode-1, "text");
	SetProperty ("text:label.text", val);
	
	if (Azkend_AutoplayerActive ()) then
		OnClick ("Ok");
	end;
end;

function OnLeave ()
    
end;


function OnClick (name)

	Print ("OnClick " .. name .. "\n");
	
	if (name == "TryAgain") then	
	
		Azkend_ResetHiddenGame ();
		lev_num_completed = GetGameValue ("level_number")-1;
		episode = math.floor (lev_num_completed / 7);
		Print ("Episode number is "..episode.."\n");
		SwitchScreen ("HiddenWorld"..episode);
		return 34;
	end;	
	
	if (name == "Ok") then
	    	PlaySound ("ui/sfx/panel_move.ogg");
	    	level_number = GetGameValue ("level_number");
    		SwitchScreen ("WorldMap");
		return;
	end;

end;


function OnUpdate (tdelta)

	akey = GetActiveScreenAnimKey ();

	trans = math.sin (0.5*3.1415926535 * GetActiveScreenTransPhase ());
	--SetProperty ("panel:position_offset.y", (1-trans) * 200);
	SetProperty ("panel:alpha", trans);
	SetProperty ("frames:alpha", trans);
	SetProperty ("fader:alpha", trans + trans * 0.05 * math.sin (2*3.141592*akey));

  SetProperty ("pic:scale", 0.2 + 0.8 * trans);
  SetProperty ("pic:angle", (1-trans) * 6);
  SetProperty ("pic:position_offset.y", -200 * (1-trans));
  
	if (IsTopScreen (GetProperty ("/:name")) and GetActiveScreenTransPhase () >= 1 and Azkend_AutoplayerActive ()) then
		OnClick ("Ok");
	end;

end;

function OnDraw ()

end;
